<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><?php echo e($title); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">All <?php echo e($title); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-12">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All <?php echo e($title); ?></h3>
                        </div>
                        <div class="card-body overflow-x">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col border-bottom-0" width="5%">#Task ID</th>
                                        <th scope="col border-bottom-0">Worker</th>
                                        <th scope="col border-bottom-0">Job Owner</th>
                                        <th scope="col border-bottom-0">Title</th>
                                        <th scope="col border-bottom-0">Verify Work</th>
                                        <th scope="col border-bottom-0" width="8%">Status</th>
                                        <th scope="col border-bottom-0" width="8%">Date Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($data->id); ?></td>
                                            <td><?php echo e(user_name($data->user_id)); ?><br> <small>(<?php echo e(user_code($data->user_id)); ?>)</small></td>
                                            <td><?php echo e(job_owner($data->job_id)); ?><br> <small>Job ID: <?php if(find_job($data->job_id)): ?><?php echo e(find_job($data->job_id)->code); ?><?php endif; ?></small></td>
                                            <td><?php echo e(job_title($data->job_id)); ?></td>
                                            <td>
                                                <a href="javascript:;" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#edit_<?php echo e($key); ?>">
                                                    Verify
                                                </a>
                                            </td>
                                            <td>
                                                <?php if($data->status == 1): ?>
                                                    <span class="badge bg-success">Satisfied</span>
                                                <?php elseif($data->status == 2): ?>
                                                    <span class="badge bg-danger">Unsatisfied</span>
                                                <?php elseif($data->status == 3): ?>
                                                    <span class="badge bg-danger">Reported</span>
                                                <?php else: ?>
                                                    <span class="badge bg-warning">Pending</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo e(\Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')); ?>

                                            </td>
                                        </tr>
                                        
                                        <div class="modal fade" id="edit_<?php echo e($key); ?>" tabindex="-1" role="dialog"
                                            aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <?php if($data->screenshot_proof != NULL): ?>
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel">Verify Work:</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body row">
                                                            
                                                            <br>
                                                            <?php
                                                                $s_shots = explode("|", $data->screenshot_proof);
                                                            ?>
                                                            <?php if($s_shots): ?>
                                                                <?php $__currentLoopData = $s_shots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $s_shot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div class="mb-5">
                                                                        <span class="d-block text-center text-sm font-weight-bold text-uppercase" style="color:green;"><i class="fas fa-image"></i><b> Screenshot: <?php echo e($key + 1); ?></b></span>
                                                                        
                                                                        <img src="<?php echo e(URL::to($s_shot)); ?>" class="img-fluid c-pointer mt-2" style="height: 100%; width: 100%;" alt="Screen Shot" onclick="viewImage('<?php echo e(URL::to($s_shot)); ?>')">
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="modal-body row">
                                                        <div class="form-group col-lg-12 col-md-12 col-12">
                                                            <label for="categoryName">Work Proof</label>
                                                            <div>
                                                                <?php echo e($data->work_proof); ?>

                                                            </div>
                                                        </div>
                                                        <div class="form-group col-lg-12 col-md-12 col-12">
                                                            <label for="categoryName">Required Proof</label>
                                                            <div>
                                                               <?php if(find_job($data->job_id)): ?><?php echo e(find_job($data->job_id)->required_proof); ?><?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <p id="modal-dis-msg-default" class="font-weight-500" style="padding: 5px;margin-top: 10px;color: red;"><?php echo e($data->reason); ?></p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                        <?php if($data->status == 0): ?>
                                                            <a href="<?php echo e(route('admin.job-work-approve', $data->id)); ?>" onclick="return confirm(' You want to approved?');" class="btn btn-sm btn-success">Approve</a>
                                                        <?php endif; ?>
                                                        <a href="<?php echo e(route('admin.job-work-delete', $data->id)); ?>" onclick="return confirm(' You want to delete?');" class="btn btn-sm btn-danger">Delete</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
                "pageLength": 3000, // Set the number of items per page
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });

        function depositApproved(id) {
            if (confirm("Are you sure?")) {
                document.getElementById('deposit-approved-'+id).submit();
            }
            return false;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/backend/pages/job-manage/job-work.blade.php ENDPATH**/ ?>